<?xml version='1.0' encoding='utf-8' ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<STYLE>
		H1: {COLOR: blue FONT-FAMILY: Arial; FONT-SIZE: 16pt; font-weight: bold}
		H2: {COLOR: blue FONT-FAMILY: Arial; FONT-SIZE: 14pt; font-weight: bold}
		H3: {COLOR: red FONT-FAMILY: Arial; FONT-SIZE: 12pt; font-weight: bold}
		H4: {COLOR: green FONT-FAMILY: Arial; FONT-SIZE: 10pt; font-weight: bold}
		SubTotal {COLOR: green;  FONT-FAMILY: Arial}
		BODY {COLOR: blue; FONT-FAMILY: Arial; FONT-SIZE: 10pt;}
		TR.clsOdd { background-Color: beige;  }
		TR.clsEven { background-color: #cccccc; }
		</STYLE>

	
		<head><H1>Current Topology</H1></head>
		<xsl:apply-templates select="/StoragePro/sitesTbl"/> 
		<xsl:apply-templates select="/StoragePro/clustersTbl"/> 
		<xsl:apply-templates select="/StoragePro/DisasterRecoveryTbl"/> 
		
	</xsl:template>


	<xsl:template match="/StoragePro/sitesTbl">
	<p>
	<xsl:apply-templates select="sites"/> 
	</p>
	</xsl:template>
	
	<xsl:template match="sites">
	<p>
	<H2>Site : <xsl:value-of select="name"/> </H2>
	<H2>--------------------------------------------------------------------------------------------------------------</H2>
	<xsl:apply-templates select="clustersTbl"/> 
	</p>
	</xsl:template>
	
	<xsl:template match="clustersTbl">
	<p>
	<xsl:apply-templates select="clusters"/> 
	</p>
	</xsl:template>
	
	<xsl:template match="/StoragePro/clustersTbl">
	<p>
	<H2>Single Clusters</H2>
	<H2>--------------------------------------------------------------------------------------------------------------</H2>
	<xsl:apply-templates select="clusters"/>
	</p>
	</xsl:template>
	
	<xsl:template match="/StoragePro/DisasterRecoveryTbl">
	<p>
	<H2>Disaster Recovery</H2>
	<H2>--------------------------------------------------------------------------------------------------------------</H2>
	<H4>Standalone Pairs</H4>
	<xsl:apply-templates select="pairsTbl"/> 
	<xsl:apply-templates select="cgTbl"/>
	</p>
	</xsl:template>	
	
	<!-- We disabled here because we want to display one table for all Pairs
	     Therefore we call directly to pairsTbl, if we will call to pairs then a table
	     will be created for each pair
	<xsl:template match="pairsTbl">
	<p>
	<xsl:apply-templates select="pairs"/> 
	</p>
	</xsl:template>
	-->
	
	<!-- This is Example on how to display a table for each CG -->
	<xsl:template match="cgTbl">
	<p>
	<xsl:apply-templates select="cg"/> 
	</p>
	</xsl:template>


	
	<xsl:template match="clusters">	
				<H3> Cluster : <xsl:value-of select="name"/> </H3>
				<ul>
				<H4>V-Switches</H4>
				<xsl:for-each select="./vswitchesTbl/vswitches">
					<li> Name: <xsl:value-of select="name"/> </li>
					<li> Management IP: <xsl:value-of select="managementIP"/> </li>
					<table border="1">
						<tr bgcolor="yellow">
					            <td style="text-align:center" colspan="4">
					                <BODY>IPs Table</BODY>					         
					            </td>
        					</tr>
						<tr bgcolor="lightgreen">
							<td> IP </td>
							<td> Mask </td>
							<td> Activity </td>
							<td> Interface </td>
						</tr>
						<xsl:for-each select="./IPsTbl/ips">
						<tr>
							<td> <xsl:value-of select="ip"/> </td>
							<td> <xsl:value-of select="mask"/> </td>
							<td> <xsl:value-of select="activity"/> </td>
							<td> <xsl:value-of select="interface"/> </td>
						</tr>
						</xsl:for-each>

					</table>
					<ul/>
					<table border="1">
						<tr bgcolor="yellow">
						    <td style="text-align:center" colspan="4">
							<BODY>Portals Table</BODY>					         
						    </td>
        					</tr>
						<tr bgcolor="lightgreen">
							<td> IP </td>
							<td> Port </td>
							<td> Role </td>
							<td> Tag </td>
						</tr>
						<xsl:for-each select="./portalsTbl/portals">
						<tr>
							<td> <xsl:value-of select="ip"/> </td>
							<td> <xsl:value-of select="port"/> </td>
							<td> <xsl:value-of select="role"/> </td>
							<td> <xsl:value-of select="tag"/> </td>
						</tr>
						</xsl:for-each>

					</table>
					<ul/>
				</xsl:for-each>


				<ul><H4>Volumes</H4></ul>
				<table border="1">
					<tr bgcolor="yellow">
						<td> Name </td>
						<td> State </td>
						<td> Type </td>
						<td> # of Blocks </td>
						<td> Block Size </td>
						<td> Redundant? </td>
						<td> Children </td>
					</tr>
					<xsl:apply-templates select="volumesTbl"/>

				</table>


				<ul><H4>Targets</H4></ul>
				<xsl:for-each select="./targetsTbl/targets">
					<li> Name: <xsl:value-of select="name"/> </li>
					<li> Exposed On: <xsl:value-of select="exposedOn"/> </li>
					<table border="1">
						<tr bgcolor="yellow">
						    <td style="text-align:center" colspan="3">
							<BODY>LU's Table</BODY>					         
						    </td>
        					</tr>					
						<tr bgcolor="lightgreen">
							<td> LUN </td>
							<td> Volume </td>
							<td> Serial # </td>
						</tr>
						<xsl:for-each select="./LUsTbl/lus">
						<tr>
							<td> <xsl:value-of select="LUN"/> </td>
							<td> <xsl:value-of select="volumeName"/> </td>
							<td> <xsl:value-of select="SN"/> </td>
						</tr>
						</xsl:for-each>
					</table>
				</xsl:for-each>
				
				<ul><H4> Disks</H4></ul>
				<xsl:for-each select="./storageTbl/disksTbl/disks">
					<li>Alias: <xsl:value-of select="alias"/></li>
					<li>Total Capacity: <xsl:value-of select="totalCapacity"/> </li>
					<li>Free Capacity: <xsl:value-of select="FreeCapacity"/> </li>
					<li>Block Size: <xsl:value-of select="blockSize"/> </li>					
					<table border="1">
						<tr bgcolor="yellow">
						    <td style="text-align:center" colspan="5">
							<BODY>Subdisks Table</BODY>					         
						    </td>
        					</tr>						
						<tr bgcolor="lightgreen">
							<th> Alias </th>
							<th> Start Addr </th>
							<th> End Addr </th>
							<th> Capacity </th>
							<th> Block Size </th>
						</tr>
						<xsl:for-each select="./SubdisksTbl/subdisks">
						<tr>
							<td> <xsl:value-of select="alias"/> </td>
							<td> <xsl:value-of select="startAddress"/> </td>
							<td> <xsl:value-of select="endAddress"/> </td>
							<td> <xsl:value-of select="totalCapacity"/> </td>
							<td> <xsl:value-of select="blockSize"/> </td>
						</tr>
						</xsl:for-each>
					</table>
				</xsl:for-each>
				
				</ul>
	</xsl:template>

<!-- This code tends to display the volumes recursivly, for example:

    Con1 = Mir1 + Mir2
           Mir1 = sub1 + sub2
           Mir2 = sub3 + sub4
    it will display in a table as follows:
    
    Con1
    Mir1
    sub1
    sub2
    Mir2
    sub3
    sub4
-->    

	<xsl:template match="volumesTbl">
	<p>
	<xsl:apply-templates select="volumes"/> 
	</p>
	</xsl:template>

	<xsl:template match="volumes">	
		<tr>
			<td> <xsl:value-of select="name"/> </td>
			<td> <xsl:value-of select="state"/> </td>
			<td> <xsl:value-of select="type"/> </td>
			<td> <xsl:value-of select="numberOfBlocks"/> </td>
			<td> <xsl:value-of select="blockSize"/> </td>
			<td> <xsl:value-of select="redundant"/> </td>
			<td>
			<xsl:for-each select="./children">
				[ <xsl:value-of select="name"/> ]
			</xsl:for-each>
			</td>
		</tr>
		<xsl:apply-templates select="children"/>
	</xsl:template>

	<xsl:template match="children">	
		<tr>
			<td> <xsl:value-of select="name"/> </td>
			<td> <xsl:value-of select="state"/> </td>
			<td> <xsl:value-of select="type"/> </td>
			<td> <xsl:value-of select="numberOfBlocks"/> </td>
			<td> <xsl:value-of select="blockSize"/> </td>
			<td> <xsl:value-of select="redundant"/> </td>
			<td>
			<xsl:for-each select="./children">
				[ <xsl:value-of select="name"/> ]
			</xsl:for-each>
			</td>
		</tr>
		<xsl:apply-templates select="children"/>
	</xsl:template>


	<xsl:template match="pairsTbl">	
		<table border="1">
			<tr bgcolor="yellow">
			    <td style="text-align:center" colspan="11">
				<BODY>Pairs Table</BODY>					         
			    </td>
			</tr>
			<tr bgcolor="lightgreen">
				<td> Type </td>
				<td> Primary Site </td>
				<td> Primary Volume </td>
				<td> Secondary Site </td>
				<td> Secondary Volume </td>
				<td> Local Cluster </td>
				<td> Remote Cluster </td>
				<td> Mode </td>
				<td> Initial Sync Type </td>
				<td> Initial Sync State </td>
				<td> Replication State </td>
			</tr>
			<xsl:for-each select="./pairs">
			<tr bgcolor="#dddd">
				<td> <xsl:value-of select="type"/> </td>
				<td> <xsl:value-of select="primarySite"/> </td>
				<td> <xsl:value-of select="primaryVolume"/> </td>
				<td> <xsl:value-of select="secondarySite"/> </td>
				<td> <xsl:value-of select="secondaryVolume"/> </td>
				<td> <xsl:value-of select="localCluster"/> </td>
				<td> <xsl:value-of select="remoteCluster"/> </td>
				<td> <xsl:value-of select="mode"/> </td>
				<td> <xsl:value-of select="initialSyncType"/> </td>
				<td> <xsl:value-of select="initialSyncState"/> </td>
				<td> <xsl:value-of select="replicationState"/> </td>
				<xsl:if test="count(./extendedAsyncPairDetails)>0">
					<tr>
					    <td style="text-align:center" colspan="5"> Pair Journals and Snapshots   </td>				
					    <td style="text-align:center" colspan="6"> Pair Data and Pits Statistics </td>
					</tr>
					<tr>
					    <td colspan="5">
						<li>Primary Journal  : <xsl:value-of select="./extendedAsyncPairDetails/primaryJournal"/></li>
						<li>Secondary Journal: <xsl:value-of select="./extendedAsyncPairDetails/secondaryJournal"/></li>					         
						<li>Primary Snapshot: <xsl:value-of select="./extendedAsyncPairDetails/primarySnapshot"/></li>					         
						<li>Secondary Snapshot: <xsl:value-of select="./extendedAsyncPairDetails/secondaryJournal"/></li>			    
					    </td>				
					    <td colspan="6">
						<li>Pending Data: <xsl:value-of select="./extendedAsyncPairDetails/pendingData"/></li>					         
						<li>Pending Pits: <xsl:value-of select="./extendedAsyncPairDetails/pendingPits"/></li>					         
						<li>Not Replicated Data: <xsl:value-of select="./extendedAsyncPairDetails/notReplicatedData"/></li>					         
						<li>Not Replicated Pits: <xsl:value-of select="./extendedAsyncPairDetails/notReplicatedPits"/></li>					         
						<li>Not Merged Pits: <xsl:value-of select="./extendedAsyncPairDetails/notMergedPits"/></li>					         
						<li>Last Merged Pit: <xsl:value-of select="./extendedAsyncPairDetails/lastMergedPit"/></li>					         

					    </td>
					</tr>
				</xsl:if>	
			</tr>

			
			</xsl:for-each>
		</table>
		
	</xsl:template>


	<xsl:template match="cg">	
		<H4>Consistency Groups</H4>
		<li>Alias: <xsl:value-of select="alias"/></li>	
		<li>Replication Policy: <xsl:value-of select="replicationPolicy"/></li>	
		<li>Transfer Policy: <xsl:value-of select="transferPolicy"/></li>
		<li>Merge Policy: <xsl:value-of select="mergePolicy"/></li>
		<H4>CG Pairs</H4>
		<xsl:apply-templates select="pairsTbl"/> 
		
	</xsl:template>
	
	
	
<!-- Old , instead we use the ready pair templates
	<xsl:template match="cg">	
		<H4>Consistency Groups</H4>
		<li>Alias: <xsl:value-of select="alias"/></li>	
		<li>Replication Policy: <xsl:value-of select="replicationPolicy"/></li>	
		<li>Transfer Policy: <xsl:value-of select="transferPolicy"/></li>
		<li>Merge Policy: <xsl:value-of select="mergePolicy"/></li>
		
		<table border="1">
			<tr bgcolor="yellow">
			    <td style="text-align:center" colspan="10">
				<BODY>CG's Pairs Table [Async]</BODY>					         
			    </td>
			</tr>
			<tr>
				<td> Primary Site </td>
				<td> Primary Volume </td>
				<td> Secondary Site </td>
				<td> Secondary Volume </td>
				<td> Local Cluster </td>
				<td> Remote Cluster </td>
				<td> Mode </td>
				<td> Initial Sync Type </td>
				<td> Initial Sync State </td>
				<td> Replication State </td>
			</tr>
			<tr>
			    <td colspan="10"/>
			</tr>			
			<xsl:for-each select="./pairsTbl/pairs">
			<tr>
				<td> <xsl:value-of select="primarySite"/> </td>
				<td> <xsl:value-of select="primaryVolume"/> </td>
				<td> <xsl:value-of select="secondarySite"/> </td>
				<td> <xsl:value-of select="secondaryVolume"/> </td>
				<td> <xsl:value-of select="localCluster"/> </td>
				<td> <xsl:value-of select="remoteCluster"/> </td>
				<td> <xsl:value-of select="mode"/> </td>
				<td> <xsl:value-of select="initialSyncType"/> </td>
				<td> <xsl:value-of select="initialSyncState"/> </td>
				<td> <xsl:value-of select="replicationState"/> </td>
				<tr>
				    <td style="text-align:center" colspan="5"> Pair Journals and Snapshots   </td>				
				    <td style="text-align:center" colspan="5"> Pair Data and Pits Statistics </td>
				</tr>
				<tr>
				    <td colspan="5">
					<li>Primary Journal  : <xsl:value-of select="./extendedAsyncPairDetails/primaryJournal"/></li>
					<li>Secondary Journal: <xsl:value-of select="./extendedAsyncPairDetails/secondaryJournal"/></li>					         
					<li>Primary Snapshot: <xsl:value-of select="./extendedAsyncPairDetails/primarySnapshot"/></li>					         
					<li>Secondary Snapshot: <xsl:value-of select="./extendedAsyncPairDetails/secondaryJournal"/></li>			    
				    </td>				
				    <td colspan="5">
					<li>Pending Data: <xsl:value-of select="./extendedAsyncPairDetails/pendingData"/></li>					         
					<li>Pending Pits: <xsl:value-of select="./extendedAsyncPairDetails/pendingPits"/></li>					         
					<li>Not Replicated Data: <xsl:value-of select="./extendedAsyncPairDetails/notReplicatedData"/></li>					         
					<li>Not Replicated Pits: <xsl:value-of select="./extendedAsyncPairDetails/notReplicatedPits"/></li>					         
					<li>Not Merged Pits: <xsl:value-of select="./extendedAsyncPairDetails/notMergedPits"/></li>					         
					<li>Last Merged Pit: <xsl:value-of select="./extendedAsyncPairDetails/lastMergedPit"/></li>					         
				    
				    </td>
				</tr>
			</tr>
			</xsl:for-each>
		</table>
		
	</xsl:template>
-->

</xsl:stylesheet>

